(*| 21:14 19/06/1993 *)
PROGRAM BWSHELL;

{$M 16384,0,0}

USES
  Crt,Dos,StdTypes,KeyBoard;

CONST
  FilesPerCol = 25;
  MaxFileNum = FilesPerCol*8;

TYPE
  TString3  = STRING[3];
  TString50 = STRING[50];
  TFileBody = STRING[8];

VAR
  Player,FSPlayer: TString50;
  FileExt: TString3;
  Files: ARRAY[1..MaxFileNum] OF TFileBody;
  SelectedFileNum,HiFileNum: INTEGER;
  AddExt,Done: BOOLEAN;

PROCEDURE PlayThis(FileName,Player: TString50);
BEGIN
  ClrScr;
  Writeln(FileName);
  IF AddExt THEN
    EXEC(Player,FileName+'.'+FileExt)
  ELSE
    EXEC(Player,FileName);
  ClrScr;
END;

PROCEDURE InitFiles;
VAR
  I: INTEGER;
BEGIN
  FOR I := 1 TO MaxFileNum DO
    Files[I] := '';
  HiFileNum := 0;
  SelectedFileNum := 1;
  AddExt := FALSE;
  Done := FALSE;
END;

PROCEDURE SearchFiles(FileExt: TString3);
VAR
  SR: SearchRec;
  ThisFile: TFileBody;
BEGIN
  FindFirst('*.'+FileExt,AnyFile,SR);
  IF DosError <> 0 THEN BEGIN
    Writeln('Unable to locate any files *.',FileExt);
    HALT;
  END;
  WHILE DosError = 0 DO BEGIN
    INC(HiFileNum);
    WITH SR DO
      ThisFile := COPY(Name,1,POS('.',Name)-1);
    Files[HiFileNum] := ThisFile;
    IF HiFileNum = MaxFileNum THEN
      EXIT;
(*
    Write(ThisFile);
    IF Length(ThisFile) < 8 THEN
      Write(' ':8 - Length(ThisFile));
*)
    FindNext(SR);
  END;
END;

PROCEDURE ShowFiles;
VAR
  I,X,Y: INTEGER;
BEGIN
  X := 2;
  Y := 1;
  IF HiFileNum > 0 THEN
    FOR I := 1 TO HiFileNum DO BEGIN
      GotoXY(X,Y);
      Write(Files[I]);
      INC(Y);
      IF Y > FilesPerCol THEN BEGIN
        Y := 1;
        INC(X,10);
      END;
    END;
END;

PROCEDURE ShowSelectedFile(Hi: BOOLEAN);
VAR
  X,Y: INTEGER;
BEGIN
  X := (((SelectedFileNum-1) DIV FilesPerCol) * 10) + 2;
  Y := ((SelectedFileNum-1) MOD FilesPerCol) + 1;
  GotoXY(X,Y);
  IF Hi THEN
    HighVideo;
  Write(Files[SelectedFileNum]);
  NormVideo;
END;

PROCEDURE SelectFile;
VAR
  Key: CHAR;
  KeyFunc: KeyType;
  Selected: BOOLEAN;
BEGIN
  Selected := FALSE;
  REPEAT
    ShowSelectedFile(TRUE);
    REPEAT
    UNTIL KeyReady;
    GetKey(Key,KeyFunc);
    ShowSelectedFile(FALSE);
    CASE KeyFunc OF
      CUp     : IF SelectedFileNum > 1 THEN
                  DEC(SelectedFileNum);
      CDown   : IF SelectedFileNum < HiFileNum THEN
                  INC(SelectedFileNum);
      CLeft   : IF SelectedFileNum > FilesPerCol THEN
                  DEC(SelectedFileNum,FilesPerCol);
      CRight  : IF SelectedFileNum < HiFileNum+1-FilesPerCol THEN
                  INC(SelectedFileNum,FilesPerCol);
      CHome   : SelectedFileNum := 1;
      CEnd    : SelectedFileNum := HiFileNum;
      CPgUp   : SelectedFileNum := SelectedFileNum
                                     - ((SelectedFileNum -1) MOD FilesPerCol);
      CPgDown : SelectedFileNum := SelectedFileNum + FilesPerCol
                                     - (SelectedFileNum MOD FilesPerCol);
      ESC     : Done := TRUE;
      RET     : Selected := TRUE;
    END;
    IF SelectedFileNum > HiFileNum THEN
      SelectedFileNum := HiFileNum;
  UNTIL Done OR Selected;
END;

BEGIN
  ClrScr;
  InitFiles;
  IF ParamCount > 1 THEN BEGIN
    AddExt := ParamCount > 2;
    Player := ParamStr(2);
    FileExt := ParamStr(1);
    FSPlayer := FSearch(Player,GetEnv('PATH'));
    IF Length(FSPlayer) = 0 THEN BEGIN
      Writeln('Unable to locate ',Player,' on path');
      HALT;
    END;
  END ELSE IF ParamCount = 1 THEN BEGIN
    IF (ParamStr(1) = '/V') OR (ParamStr(1) = '/v') THEN BEGIN
      Player := 'C:\SB\VOXKIT\VPLAY.EXE';
      FileExt := 'VOC';
    END ELSE IF (ParamStr(1) = '/C') OR (ParamStr(1) = '/c') THEN BEGIN
      Player := 'C:\SB\PLAYCMF\PLAYCMF.EXE';
      FileExt := 'CMF';
    END ELSE IF (ParamStr(1) = '/F') OR (ParamStr(1) = '/f') THEN BEGIN
      Player := 'AAPLAY.EXE';
      FileExt := 'FLI';
      AddExt := TRUE;
    END ELSE BEGIN
      Writeln('BWSHELL Program by B Whitnall, v1.1, 1993');
      Writeln('Usage:  BWSHELL ext player.exe [addext]');
      HALT;
    END;
  END ELSE BEGIN
    Writeln('BWSHELL Program by B Whitnall, v1.1, 1993');
    Writeln('Usage:  BWSHELL ext player.exe [addext]');
    HALT;
  END;
  SearchFiles(FileExt);
  REPEAT
    ShowFiles;
    SelectFile;
    IF NOT Done THEN
      PlayThis(Files[SelectedFileNum],Player);
  UNTIL Done;
  ClrScr;
END.
